\name{contributionplot}
\alias{contributionplot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Mean Decomposition Pareto Plot
}
\description{
Plots the mean contribution of each variable to the C^2 statistic obtained from the C2.allPerms function. The graph follows a Pareto-style layout, ordering variables by the magnitude and percentage of their contribution. It also indicates the number of permutations in which each variable's contribution is statistically significant.
}
\usage{
contributionplot(varnames=NULL, X, alpha, title=NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
varnames=NULL, X, alpha, title=NULL
 \item{varnames}{ Defaults to NULL. A vector containing variable names}
 \item{X}{ list generated by C2.allPerms function, containing each permutation contribution and respective p-value }
 \item{alpha}{ an alpha value used to define the variables significance by compairing their p-values to alpha}
 \item{title}{ plot title}
}

\value{
A Pareto plot showing the mean contribution of each variable to the C^2 statistic. The plot includes information on the number of permutations, the mean and percentage contribution of each variable, and the number of permutations in which the variable is significant, based on its p-value compared to the specified alpha level.
}
\references{
Paper (pending complete bibliographic reference when available).
}
\author{
Dr. Burcu Aytaçoğlu (\email{burcuaytacoglu@gmail.com}),
Dr. Diana Barraza-Barraza (\email{diana.barraza@ujed.mx}),
Dr. Víctor G. Tercero-Gómez (\email{victor.tercero@tec.mx}),
Dr. A. Eduardo Cordero-Franco (\email{lalo.cordero@gmail.com})
}

\examples{
k<-3
sigma0 = matrix(diag(rep(1,k)),ncol = k)
mu0 = matrix(c(0,0,0), ncol = 1)
Weights = diag(c(0.5, 0.25,0.25))

library(mvtnorm)
set.seed(1000)
X = matrix(ncol= 1, data = rmvnorm(n = 1, mean = mu0, sigma = sigma0))
Z = (X - mu0)/sqrt(as.numeric(diag(sigma0)))
Corr<-get.R(Sigma0 = sigma0)

X<-c2decomp(z = Z, W = Weights, R = Corr)
contributionplot(varnames = paste0("x",1:3), X = X, alpha = .05, title = "Z")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
% \keyword{ ~kwd1 }
% \keyword{ ~kwd2 }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
