% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi2cub.R
\name{chi2cub}
\alias{chi2cub}
\title{Pearson \eqn{X^2} statistic}
\usage{
chi2cub(m,ordinal,W,pai,gama)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{W}{Matrix of covariates for the feeling component}

\item{pai}{Uncertainty parameter}

\item{gama}{Vector of parameters for the feeling component, with length equal to NCOL(W)+1
to account for an intercept term (first entry of \code{gama})}
}
\value{
A list with the following components:
\item{df}{Degrees of freedom}
\item{chi2}{Value of the Pearson fitting measure}
\item{dev}{Deviance indicator}
}
\description{
Compute the \eqn{X^2} statistic of Pearson for CUB models with one or two discrete
covariates for the feeling component.
}
\details{
No missing value should be present neither
for \code{ordinal} nor for covariate matrices: thus, deletion or imputation procedures should be
preliminarily run.
}
\examples{
data(univer)
m<-7
pai<-0.3
gama<-c(0.1,0.7)
ordinal<-univer$informat; W<-univer$gender;
pearson<-chi2cub(m,ordinal,W,pai,gama)
degfree<-pearson$df
statvalue<-pearson$chi2
deviance<-pearson$dev
}
\references{
Tutz, G. (2012). \emph{Regression for Categorical Data}, Cambridge University Press, Cambridge
}
\keyword{htest}
