% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcush.R
\name{simcush}
\alias{simcush}
\title{Simulation routine for CUSH models}
\usage{
simcush(n,m,delta,shelter)
}
\arguments{
\item{n}{Number of simulated observations}

\item{m}{Number of ordinal categories}

\item{delta}{Shelter parameter}

\item{shelter}{Category corresponding to the shelter choice}
}
\description{
Generate \eqn{n} pseudo-random observations following the distribution of a CUSH
model without covariates.
}
\examples{
n<-200
m<-7
delta<-0.3
shelter<-3
simulation<-simcush(n,m,delta,shelter)
plot(table(simulation),xlab="Ordinal categories",ylab="Frequencies")
}
\seealso{
\code{\link{probcush}}
}
\keyword{distribution}
