% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varmatCUB.R
\name{varmatCUB}
\alias{varmatCUB}
\title{Variance-covariance matrix for CUB models}
\usage{
varmatCUB(ordinal,m,param,Y=0,W=0,X=0,shelter=0)
}
\arguments{
\item{ordinal}{Vector of ordinal responses}

\item{m}{Number of ordinal categories}

\item{param}{Vector of parameters for the specified CUB model}

\item{Y}{Matrix of selected covariates to explain the uncertainty component (default: no covariate is included
in the model)}

\item{W}{Matrix of selected covariates to explain the feeling component (default: no covariate is included
in the model)}

\item{X}{Matrix of selected covariates to explain the shelter effect (default: no covariate is included
in the model)}

\item{shelter}{Category corresponding to the shelter choice (default: no shelter effect is included in the
model)}
}
\description{
Compute the variance-covariance matrix of parameter estimates for CUB models with or without
covariates for the feeling and the uncertainty parameter, and for extended CUB models with shelter effect.
}
\details{
The function checks if the variance-covariance matrix is positive-definite: if not,
it returns a warning message and produces a matrix with NA entries.  No missing value should be present neither
for \code{ordinal} nor for covariate matrices: thus, deletion or imputation procedures should be preliminarily run.
}
\examples{
data(univer)
m<-7
### CUB model with no covariate
pai<-0.87; csi<-0.17 
param<-c(pai,csi)
varmat<-varmatCUB(univer$global,m,param)
#######################
### and with covariates for feeling
data(univer)
m<-7
pai<-0.86; gama<-c(-1.94,-0.17)
param<-c(pai,gama)
ordinal<-univer$willingn; W<-univer$gender      
varmat<-varmatCUB(ordinal,m,param,W)
#######################
### CUB model with uncertainty covariates
data(relgoods)
m<-10
naord<-which(is.na(relgoods$Physician))
nacov<-which(is.na(relgoods$Gender))
na<-union(naord,nacov)
ordinal<-relgoods$Physician[-na]
Y<-relgoods$Gender[-na]
bet<-c(-0.81,0.93); csi<-0.20
varmat<-varmatCUB(ordinal,m,param=c(bet,csi),Y=Y)
#######################
### and with covariates for both parameters
data(relgoods)
m<-10
naord<-which(is.na(relgoods$Physician))
nacov<-which(is.na(relgoods$Gender))
na<-union(naord,nacov)
ordinal<-relgoods$Physician[-na]
W<-Y<-relgoods$Gender[-na]
gama<-c(-0.91,-0.7); bet<-c(-0.81,0.93)
varmat<-varmatCUB(ordinal,m,param=c(bet,gama),Y=Y,W=W)
#######################
### Variance-covariance for a CUB model with shelter
m<-8; n<-300
pai1<-0.5; pai2<-0.3; csi<-0.4
shelter<-6
pr<-probcubshe1(m,pai1,pai2,csi,shelter)
ordinal<-sample(1:m,n,prob=pr,replace=TRUE)
param<-c(pai1,pai2,csi)
varmat<-varmatCUB(ordinal,m,param,shelter=shelter)
}
\references{
Piccolo D. (2006). Observed Information Matrix for MUB Models,
\emph{Quaderni di Statistica}, \bold{8}, 33--78 \cr
Iannario, M. (2012). Modelling shelter choices in ordinal data surveys.
\emph{Statistical Modelling and Applications}, \bold{21}, 1--22 \cr
Iannario M. and Piccolo D. (2016b). A generalized framework for modelling ordinal data.
\emph{Statistical Methods and Applications}, \bold{25}, 163--189.\cr
}
\seealso{
\code{\link{vcov}}, \code{\link{cormat}}
}
\keyword{htest}
