

#' Title
#'
#' @param Prob A vector of probability predictions provided by the predicted model
#' @param yt A vector 0/1 with the dichotomic outcome values
#'
#' @return A curve that describe the efficacy of the marker for different event missclassified rates
#' @export
#'
#' @examples
#' #'Prob<-c(rnorm(10000,0.4,0.1),rnorm(10000,0.5,0.05))
#'yt<-rep(c(0,1),c(10000,10000))
#'Efficacy_curve(Prob,yt)

Efficacy_curve<-function(Prob,yt){
  Resultados<-vector(mode="numeric",length=200)
  for(i in seq(1,1000))
    Resultados[i]<-Efficacy(Prob,yt,i/10)

  DT<-data.frame(seq(1,1000)/10,Resultados)
  names(DT)<-c("x","y")

  Modelo<-spline(DT$x,DT$y)
  plot(DT$x,DT$y,type="l",lwd=2,col="blue",xlab="Missing events",ylab="Model efficacy",ylim=c(min(DT$y),max(DT$y)+1),tck=1,fg="lightgray")
  #lines(Modelo$x,Modelo$y,type="l",lwd=2,xlab="Missing cancer",ylab="Model efficacy",ylim=c(20,30),col="yellow")
  #points(DT$x[which.max(DT$y)],DT$y[which.max(DT$y)],pch=9,col="purple",lwd=2)
  lines(c(DT$x[which.max(DT$y)],DT$x[which.max(DT$y)]),c(0,DT$y[which.max(DT$y)]),lty=3,col="lightblue")
  text(DT$x[which.max(DT$y)],DT$y[which.max(DT$y)]+1,paste("(",round(DT$x[which.max(DT$y)],digits=1),",",
                                                           round(DT$y[which.max(DT$y)],digits=1),")"))
}
