% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascvd_prevent.R
\name{ascvd_10y_prevent}
\alias{ascvd_10y_prevent}
\title{PREVENT 10-year ASCVD risk score}
\usage{
ascvd_10y_prevent(
  gender = c("male", "female"),
  age,
  sbp,
  bp_med,
  totchol,
  hdl,
  statin,
  diabetes,
  smoker,
  egfr,
  bmi,
  hba1c = NULL,
  uacr = NULL,
  zip = NULL,
  model = "auto",
  ...
)
}
\arguments{
\item{gender}{patient gender (male, female)}

\item{age}{patient age (years), between 30 and 79}

\item{sbp}{Systolic blood pressure (mm Hg)}

\item{bp_med}{Patient is on a blood pressure medication (1=Yes, 0=No)}

\item{totchol}{Total cholesterol (mg/dL)}

\item{hdl}{HDL cholesterol (mg/dL)}

\item{statin}{Patient is on a statin (1=Yes, 0=No)}

\item{diabetes}{Diabetes (1=Yes, 0=No)}

\item{smoker}{Current smoker (1=Yes, 0=No)}

\item{egfr}{Estimated glomerular filtration rate (mL/min/1.73m2)}

\item{bmi}{Body mass index (kg/m2)}

\item{hba1c}{Glycated hemoglobin (HbA1c) in percent (optional)}

\item{uacr}{Urine albumin-to-creatinine ratio in mg/g (optional)}

\item{zip}{ZIP code for Social Deprivation Index (optional)}

\item{model}{PREVENT model variant to use: "auto" (default, selects based on 
available data), "base", "hba1c", "uacr", "sdi", or "full"}

\item{...}{Additional predictors can be passed and will be ignored}
}
\value{
10-year ASCVD risk estimate (percent)
}
\description{
Computes 10-year risk for ASCVD (atherosclerotic cardiovascular disease)
using the American Heart Association PREVENT equations (2023).
}
\examples{
library(CVrisk)
# Base model (default when model = "auto" and no optional predictors provided)
ascvd_10y_prevent(
  gender = "female", age = 50,
  sbp = 160, bp_med = 1,
  totchol = 200, hdl = 45,
  statin = 0, diabetes = 1, smoker = 0,
  egfr = 90, bmi = 35
)

# Explicitly specify base model
ascvd_10y_prevent(
  gender = "female", age = 50,
  sbp = 160, bp_med = 1,
  totchol = 200, hdl = 45,
  statin = 0, diabetes = 1, smoker = 0,
  egfr = 90, bmi = 35,
  model = "base"
)

# Auto model with HbA1c (will use hba1c model variant)
ascvd_10y_prevent(
  gender = "male", age = 55,
  sbp = 140, bp_med = 0,
  totchol = 213, hdl = 50,
  statin = 0, diabetes = 0, smoker = 0,
  egfr = 90, bmi = 30,
  hba1c = 6.5
)

}
\references{
Khan SS, Matsushita K, Sang Y, Ballew SH, Grams ME, Surapaneni A, Blaha MJ,
Carson AP, Chang AR, Ciemins E, Go AS, Gutierrez OM, Hwang SJ, Jassal SK,
Kovesdy CP, Lloyd-Jones DM, Shlipak MG, Palaniappan LP, Sperling L,
Virani SS, Tuttle K, Neeland IJ, Chow SL, Rangaswami J, Pencina MJ,
Ndumele CE, Coresh J; Chronic Kidney Disease Prognosis Consortium and the
American Heart Association Cardiovascular-Kidney-Metabolic Science Advisory
Group. Development and Validation of the American Heart Association's
PREVENT Equations. Circulation. 2024 Feb 6;149(6):430-449.
}
