% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.carlboot}
\alias{plot.carlboot}
\alias{plot.carlperm}
\title{Plot the bootstrap distribution in \code{carlboot} object}
\usage{
\method{plot}{carlboot}(x, bins = 15, size = 5, xlab = NULL, ylab = NULL, title = NULL, ...)

\method{plot}{carlperm}(x, bins = 15, size = 5, xlab = NULL, ylab = NULL, title = NULL, ...)
}
\arguments{
\item{x}{The carlboot object to print.}

\item{bins}{number of bins in histogram.}

\item{size}{size of points.}

\item{xlab}{an optional character string for the x-axis label}

\item{ylab}{an optional character string for the y-axis label}

\item{title}{an optional character string giving the plot title}

\item{...}{not used}
}
\description{
Plot the bootstrap distribution returned as a \code{carlboot} object.
}
\examples{

boot_dist <- boot(ToothGrowth$len, ToothGrowth$supp, B = 1000)
plot(boot_dist)

perm_dist <- permTest(states03$ViolentCrime, states03$DeathPenalty, B = 999)
plot(perm_dist)
}
