% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_CausalMBSTS.R
\name{summary.CausalMBSTS}
\alias{summary.CausalMBSTS}
\title{Summary of causal effect estimation results obtained with \code{CausalMBSTS}}
\usage{
\method{summary}{CausalMBSTS}(object, ...)
}
\arguments{
\item{object}{An object of class 'CausalMBSTS', a result of a call to \code{\link{CausalMBSTS}}.}

\item{...}{further arguments passed to or from other methods (currently not used).}
}
\value{
Returns an object of class \code{summary.CausalMBSTS}, which is a list of data frames corresponding to each
date provided in \code{horizon} (or its default value) with the following columns:
  \item{mean}{Estimated average causal effect}
  \item{lower}{Lower bound of the two-sided (1-\code{alpha})\% credible interval. Note that \code{alpha} parameter is inherited from the object \code{object}.}
  \item{upper}{Upper bound of the two-sided (1-\code{alpha})\% credible interval}
  \item{cum.sum}{Pointwise effect}
  \item{cum.lower}{Lower bound of a (1-\code{alpha})\% credible interval of the pointwise effect}
  \item{cum.upper}{Upper bound of a (1-\code{alpha})\% credible interval of the pointwise effect}
  \item{bayes.pval}{Bayesian p-value for the average causal effect}
  \item{pct.causal.eff}{Probability of a causal effect (\%)}
}
\description{
The method extracts and computes various summaries of the causal analysis with \code{CausalMBSTS}.
}
\examples{
set.seed(1)
t <- seq(from = 0,to = 4*pi, length.out=300)
y <- cbind(3*sin(2*t)+rnorm(300), 2*cos(2*t) + rnorm(300))
dates <- seq.Date(from = as.Date("2015-01-01"), by = "week", length.out=300)
int.date <- as.Date("2020-02-27")
y[dates >= int.date,] <- y[dates >= int.date,]+2

# Causal effect estimation
causal.2 <- CausalMBSTS(y, components = c("trend", "cycle"), cycle.period = 75,
                        dates = dates, int.date = int.date, s0.r = 0.01*diag(2),
                        s0.eps = 0.1*diag(2), niter = 100, burn = 10)

sum.causal.2 <- summary(causal.2)
print(sum.causal.2, digits = 2)
sum.causal.2$horizon_default

}
