% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xposeNlme.R
\name{xposeNlme}
\alias{xposeNlme}
\title{Creates xpose database from Certara.RsNLME output files}
\usage{
xposeNlme(
  dir = "",
  modelName = "",
  dmpFile = "dmp.txt",
  dmp.txt = NULL,
  dataFile = "data1.txt",
  logFile = "nlme7engine.log",
  ConvergenceData = NULL,
  progresstxt = "progress.txt"
)
}
\arguments{
\item{dir}{Path to NLME Run directory. Current working directory is used if \code{dir} not given.}

\item{modelName}{name of the model to be written in \code{xpdb$summary$value} with run label}

\item{dmpFile}{NLME generated output file.}

\item{dmp.txt}{NLME generated output from dmpFile (substitutes dmpFile if presented).}

\item{dataFile}{Input file for NLME Run.}

\item{logFile}{engine log file}

\item{ConvergenceData}{optional data frame with Nlme convergence info.}

\item{progresstxt}{optional NLME-generated file 'progress.txt' with convergence info.
\code{ConvergenceData} has more priority if both are given.}
}
\value{
\code{xpdb} object
}
\description{
Imports results of an NLME run into xpose database
Use to import NLME model output files into \code{xpdb} object that is compatible
with existing model diagnostic function in \code{Xpose} package.
}
\details{
Not all functionality from the \code{xpose} package is supported.
}
\examples{
\donttest{
# files in arguments supposed to be in the current working directory:
xp <- xposeNlme(
  dir = getwd(),
  modelName = "PMLModel",
  dmpFile = "dmp.txt",
  dataFile = "data1.txt",
  logFile = "nlme7engine.log",
  progresstxt = "progress.txt"
)

# using dmp.txt structure and Convergence Data loaded previously:
xp <- xposeNlme(
  dir = "~/Model1/",
  modelName = "Model1",
  dmp.txt = dmp.txt,
  dataFile = "Data.csv",
  logFile = "nlme7engine.log",
  ConvergenceData = ConvergenceData
)

# explore unique covariate plots specific to Certara.Xpose.NLME:
nlme.cov.splom(xp, covColNames = c("AGE", "WT"))
nlme.par.vs.cov(xp, covColNames = c("AGE", "WT"))

res_vs_cov(xp, covariate = "AGE", res = "IWRES")

# or use existing plotting functions from the xpose package
library(xpose)
dv_vs_pred(xp)
res_vs_idv(xp)
}

}
