% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv11_vca_by_median.R
\name{cv11_vca_by_median}
\alias{cv11_vca_by_median}
\title{Variability Components Analysis by Median with Bootstrap}
\usage{
cv11_vca_by_median(data, residue_col, cleaning_event_col, n_bootstrap = 2000)
}
\arguments{
\item{data}{A data frame containing the data.}

\item{residue_col}{The name of the column containing residue percentages.}

\item{cleaning_event_col}{The name of the column containing cleaning event identifiers.}

\item{n_bootstrap}{The number of bootstrap iterations. Default is 2000.}
}
\value{
A data frame summarizing variability components analysis by median along with confidence intervals from bootstrap.
}
\description{
Perform Variability Components Analysis (VCA) by median for residue percentages based on cleaning events with bootstrap for confidence intervals.
}
\examples{
# Assuming 'Eq_DAR' is the data frame, 'DAR_Pct' is the residue column, 
# and 'CleaningEvent' is the cleaning event column.
Eq_DAR <- cv01_dfclean(data=Eq_DAR, cleaning_event_col="CleaningEvent",
residue_col="DAR", usl_col="USL" ) 
Eq_DAR <- cv03_usl_unification(data=Eq_DAR, cleaning_event_col="CleaningEvent", 
residue_col="DAR", usl_col="USL")
summary <- cv11_vca_by_median(data = Eq_DAR, residue_col = "DAR_Pct", 
cleaning_event_col = "CleaningEvent", n_bootstrap = 2000)
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
