% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{hd17}
\alias{hd17}
\title{Heating degree days}
\usage{
hd17(data, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{daily mean temperature, Celsius}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
temperature, Celsius
}
\description{
accumulated degree when TG is below 17 Celsius
}
\section{Formula}{
\deqn{HD17_j = \sum_{j-1}^{I} (17 ^ oC - TG_ij)}
}

\examples{
data(data_all)
hd17(data=data_all$tg)
}
\references{
Quayle, R. G., & Diaz, H. F. (1980). Heating degree day data applied to residential heating energy consumption. Journal of Applied Meteorology, 19(3), 241-246. \doi{10.1175/1520-0450(1980)019<0241:HDDDAT>2.0.CO;2}
}
