% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusTCR.R
\name{ClusTCR}
\alias{ClusTCR}
\title{Creates ClusTCR matrix
This function identifies similar CDR3 amino acid sequences based on the same length and V_gene}
\usage{
ClusTCR(my_file, allele = NULL, v_gene = "v_call")
}
\arguments{
\item{my_file}{uploaded file with junction_aa (CD3 sequences), variable gene.}

\item{allele}{The allele, if present as *00 will be removed if the user requires it.}

\item{v_gene}{Variable gene column name}
}
\value{
X by Y matrix of structurally related CDR3 sequences.
}
\description{
Creates ClusTCR matrix
This function identifies similar CDR3 amino acid sequences based on the same length and V_gene
}
\examples{
# Example usage of ClusTCR function with a stored file
example_file <- read.csv(system.file("extdata", "my_data.csv", package = "ClusTCR2"))
# Perform clustering using ClusTCR function
step1 <- ClusTCR(example_file, allele = FALSE)
# Print the result
print(step1)
}
