% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selvar.R
\name{selvar}
\alias{selvar}
\title{Selection of a given number of variables in each cluster.}
\usage{
selvar(part, nsel)
}
\arguments{
\item{part}{an  object of class \code{clustvar}}

\item{nsel}{the number of variables selected in each cluster.}
}
\value{
Returns a list where each element contains the  \code{nsel} selected variables.
}
\description{
This function selects in each cluster
a given number of variables  having the highest 
squared loadings. The squared loading of a variable in a cluster is its 
squared correlation (for numerical variable) and its correlation ratio (for categorical variable)
with the first PC of PCAmix applied to the variables of the cluster.
}
\details{
If the number of variables in a cluster is smaller than \code{nsel}, 
all the variables of the cluster are selected
}
\examples{
data(decathlon)
tree <- hclustvar(decathlon[,1:10])
part <- cutreevar(tree,4)
part$var
selvar(part,2) 
}
