% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterResample.R
\name{clusterResample}
\alias{clusterResample}
\title{Cluster Resampling}
\usage{
clusterResample(df, clusters, replace)
}
\arguments{
\item{df}{A data frame or data table. The original dataset to be resampled.}

\item{clusters}{A character vector of variable names that define the nested
structure of the data. The order should be from highest (outermost) to
lowest (innermost) level.}

\item{replace}{A logical vector, of the same length as \code{clusters},
indicating whether to sample with replacement at each level.}
}
\value{
A resampled data.table with the same column structure as \code{df},
  potentially with repeated or dropped rows depending on \code{replace}.
}
\description{
Performs hierarchical (clustered or nested) resampling of a data frame
across one or more grouping variables. Each level of grouping can be
resampled with or without replacement.
}
\details{
This function supports arbitrary nesting depth, and preserves the
original hierarchical structure during resampling. At each level, sampling
is done conditionally within the grouping structure defined by the higher
levels.
}
\examples{
\dontrun{
set.seed(123)
df <- expand.grid(
  school = paste0("S", 1:5),
  class  = paste0("C", 1:5),
  student = paste0("P", 1:5)
)
df$score <- rnorm(nrow(df))

resampled <- clusterResample(df, clusters = c("school", "class", "student"),
                              replace = c(TRUE, TRUE, FALSE))
}
}
\seealso{
\code{\link{clusterBootstrap}} that uses the current function.
}
\author{
Mathijs Deen
}
