% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.clusbootptest.R
\name{plot.clusbootptest}
\alias{plot.clusbootptest}
\title{Plot results of a permutation test}
\usage{
\method{plot}{clusbootptest}(x, pcol = "red", pty = 1, mfrow = c(1, 1), ...)
}
\arguments{
\item{x}{object of class \code{clusbootptest}}

\item{pcol}{color of vertical line indicating the observed Welch t test statistic}

\item{pty}{type of vertical line indicating the observed Welch t test statistic}

\item{mfrow}{vector of length 2 indicating the numbers of rows and columns in which the histograms will be drawn on the device.}

\item{...}{other arguments to be passed into the \code{hist} function.}
}
\description{
Plot results of a permutation test performed with ptest
}
\examples{
\dontrun{
medication <- medication[medication$time \%\% 1 == 0,]
set.seed(1)
permtest.1 <- ptest(data = meds, outcome = pos, within = time, between = treat, 
                    at.within = c(0,2,4,6), at.between = c(0,1), pn = 2000)
plot(permtest.1, pcol = "red", pty=2, mfrow = c(2,2), breaks="FD")}
}
\author{
Mathijs Deen, Mark de Rooij
}
