% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoNI_functions.R
\name{generate_network}
\alias{generate_network}
\title{Create network}
\usage{
generate_network(
  ResultsCoNI,
  colorVertexNetwork = TRUE,
  colorVertexTable,
  outputDir = "./",
  outputFileName = "ResultsCoNI",
  Class = NULL,
  saveFiles = TRUE
)
}
\arguments{
\item{ResultsCoNI}{The input of the function are the results of CoNI.}

\item{colorVertexNetwork}{logical. If TRUE, the table colorVertexTable has to be provided to specify vertex colors}

\item{colorVertexTable}{Table specifying the colors for the nodes (vertex features). The first column should contain the names matching the features of the vertex Data and the colors or other data can be specified in the rest of the columns}

\item{outputDir}{Output directory where the network is saved as well as the file that was used to generate the network.}

\item{outputFileName}{The name of the file used to create the network.}

\item{Class}{Optional data frame with at least two columns, first column contains all vertex features and another column the vertex feature class (column named "Class"). Necessary for treatment comparisons based on class}

\item{saveFiles}{logical. If FALSE TableForNetwork_`outputFileName`.csv and Network_`outputFileName`.graphml are not saved to disk}
}
\value{
Returns an igraph object (network) constructed from ResultsCoNI. The network includes the following network statistics
\itemize{
 \item{"degree"}{The number of the vertex adjacent edges}
 \item{"hub_score"}{The principal eigenvector of A*t(A), where A is the adjacency matrix of the graph}
 \item{"transitivity"}{Probability that the adjacent vertices of a vertex are connected}
 \item{"closeness"}{Steps required to access every other vertex from a given vertex}
 \item{"betweenness"}{(roughly) The number of geodesics (shortest paths) going through a vertex or an edge}
 \item{"eigen_centrality"}{Takes a graph (graph) and returns the eigenvector centralities of positions v within it}
 \item{"centralized_betweenness"}{The vertice-level centrality score according to the betweenness of vertices}
 \item{"centralized_closeness"}{The vertice-level centrality score according to the closeness of vertices}
 \item{"centralized_degree"}{The vertice-level centrality score according to the degrees of vertices}
}
For more details see igraph package
}
\description{
This function creates a network using as input the output of CoNI and a table specifying the colors for the nodes.
}
\examples{
#Generate Network

#Load color nodes table
data(MetColorTable)
#Assign colors according to "Class" column
MetColorTable<-assign_colorsAnnotation(MetColorTable)
#Load CoNI results
data(CoNIResultsHFDToy)

#Generate Network
HFDNetwork<-generate_network(ResultsCoNI = CoNIResultsHFDToy,
                             colorVertexNetwork = TRUE,
                             colorVertexTable = MetColorTable,
                             outputDir = "./",
                             outputFileName = "HFD",
                             saveFiles = FALSE)
}
