% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_plot.R
\name{community_plot}
\alias{community_plot}
\title{Communities by layer plot}
\usage{
community_plot(x, ...)
}
\arguments{
\item{x}{a \code{spinglass_net} object created by \code{\link{hms}}}

\item{...}{additional arguments from other methods}
}
\value{
a \code{gtable} object
}
\description{
Generate a graphical representation of the communities and layers.
}
\details{
This is an ancillary function that creates the plots seen in the manuscript,
with a heatmap-style plot on the top panel, derived from a network adjacency
matrix, and a community assignment plot on the bottom panel, separated by
layer.
}
\examples{

data(SBM_net)

\donttest{
# plot with max of two layers
SBM_netcomm <- hms(
  input_net  = SBM_net,
  spins      = 4,
  alpha      = 0,
  coolfact   = 0.90,
  tol  = 0.05,
  max_layers = 2
  )

community_plot(SBM_netcomm)
}

\donttest{
# plot with three layers
# don't run automatically on CRAN; > 5 seconds
SBM_netcomm <- hms(
  input_net  = SBM_net,
  spins      = 4,
  alpha      = 0,
  coolfact   = 0.90,
  tol  = 0.05,
  max_layers = 3
  )

community_plot(SBM_netcomm)
}

}
\seealso{
\code{link{hms}}
}
