% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcomppareto.R
\name{qwdcomppareto}
\alias{qwdcomppareto}
\title{The quantile function of a discrete composite distribution with Pareto tail}
\usage{
qwdcomppareto(p, spec, alpha, theta, log = FALSE, ...)
}
\arguments{
\item{p}{vector of probabilities}

\item{spec}{The selection of the lower tail (head) distribution}

\item{alpha}{The shape parameter of the Pareto distribution}

\item{theta}{The scale parameter of Pareto, also serve as the location parameter of the composite model}

\item{log}{logical; if TRUE, probability p are given as log(p)}

\item{...}{The parameter of the lower tail (head) distribution}
}
\value{
an object of the same length of x as the CDF evaluated at x
}
\description{
\code{qwdcomppareto} returns the quantile of a composite distribution with a Pareto upper tail given p, with a specified distribution at the lower tail.
}
\examples{
p <-seq(0.1,0.9,b=0.1)
qcomppareto(p, "weibull", alpha = 1.5, theta = 1.5, shape = 2, scale = 2)
}
