% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_func.R
\name{cf_func}
\alias{cf_func}
\title{Makes filled contour plot from function}
\usage{
cf_func(
  fn0,
  n = 100,
  xlim = c(0, 1),
  ylim = c(0, 1),
  xylim = NULL,
  batchmax = 1,
  out.col.name = NULL,
  out.name = NULL,
  pts = NULL,
  gg = FALSE,
  ...
)
}
\arguments{
\item{fn0}{function to plot, first argument must be two-dimensional}

\item{n}{number of points in each dimension}

\item{xlim}{x limits for the contour plot}

\item{ylim}{y limits for the contour plot}

\item{xylim}{x and y limits for the contour plot, use when both are same
#@param mainminmax  whether the min and max values should be shown in the title of plot}

\item{batchmax}{number of datapoints that can be computed at a time}

\item{out.col.name}{if a column needs to be selected from the function, specify it}

\item{out.name}{Selects with a $ the name from output to be used, for lists and data frames
#@param pretitle Text to be preappended to end of plot title
#@param posttitle Text to be appended to end of plot title
#@param title Title for the plot
#@param mainminmax_minmax Whether [min,max]= should be shown in title or just the numbers}

\item{pts}{Points to plot on top of contour}

\item{gg}{Should ggplot2 be used? Will use gcf_grid() instead of cf_grid().}

\item{...}{Passed to cf_grid}
}
\description{
A contour plot of the given function without sidebar by default.
It calls the function `cf_grid` to make the actual plot.
}
\examples{
cf_func(function(x){x[1]*x[2]})
cf_func(function(x)(exp(-(x[1]-.5)^2-5*(x[2]-.5)^2)))
cf_func(function(xx){exp(-sum((xx-.5)^2/.1))}, bar=TRUE)
cf_func(function(xx){exp(-sum((xx-.5)^2/.1))}, bar=TRUE, mainminmax=TRUE)
cf_func(function(x)(exp(-(x[1]-.5)^2-5*(x[2]-.5)^2)), with_lines=TRUE)
}
\references{
[1] filled.contour R function, copied function but removed part for sidebar

[2] http://stackoverflow.com/questions/16774928/removing-part-of-a-graphic-in-r, answer by P Lapointe
}
