% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicHelpChiValueConcept.R
\name{publicHelpChiValue}
\alias{publicHelpChiValue}
\alias{publicHelpValueChi}
\alias{publicHelpXiValue}
\alias{publicHelpValueXi}
\title{Compute (normalized) Public Help value Chi}
\usage{
publicHelpChiValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Public Help value Chi for specified nonnegative TU game
}
\description{
Calculates the (normalized) Public Help value Chi 
by Bertini & Stach (2015) for a nonnegative TU game.
Note that the greek letter Xi (instead of Chi) was used in the 
original paper by Bertini and Stach (2015).
}
\examples{
library(CoopGame)
v=c(0,0,0,2,2,0,2)
publicHelpChiValue(v) 
}
\references{
Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
