% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_bar_plots.R
\name{group_bar_plots}
\alias{group_bar_plots}
\title{Grouped Bar Plots Based on Sample Size}
\usage{
group_bar_plots(otu_table_bef_filtering, otu_table_aft_filtering,
num_samples_per_plot)
}
\arguments{
\item{otu_table_bef_filtering}{A data frame of OTUs before filtering where the first row is the OTU ID and column names refer to sites/sample names}

\item{otu_table_aft_filtering}{A data frame of OTUs after filtering where the first row is the OTU ID and column names refer to sites/sample names}

\item{num_samples_per_plot}{The number of samples to be displayed in each grouped bar plot.}
}
\value{
A list of interactive grouped bar plots, showing the change in sample size before and after filtering OTU table
}
\description{
The grouped_bar_plots function is designed for generating grouped
bar plots to visualize data. It takes a OTU table before filtering and OTU table
after filtering as input containing data for multiple samples and creates a
series of grouped bar plots, each representing a specific group of samples.
}
\examples{
#To run input data
core_1 <- CoreMicrobiome(
 otu_table = demo_otu,
 tax_table = demo_tax,
 metadata_table = demo_md,
 filter_type = "occupancy_fun_filter", #Or "abundance_fun_filter", Or "combined_filter"
 percent = 0.5,
 method = "css",  # Or "srs", "rrarefy", "tmm", "tmmwsp", "rle", "upperquartile", "none"
 beta_diversity_method = "jaccard",
 top_percentage = 10  # Adjust the percentage as needed for core/non-core OTUs
)
#To run grouped bar plot function
plot_group_bar <- group_bar_plots(core_1$final_otu_table_bef_filter,
core_1$final_otu_aft_filter, 10)
#To view the grouped bar plot
plot_group_bar[[1]]
}
