% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutByGene.R
\name{MutByGene}
\alias{MutByGene}
\title{Plot mutation counts for certain genes}
\usage{
MutByGene(nucmerr = nucmerr, gff3 = gff3, figurelist = FALSE, outdir = NULL)
}
\arguments{
\item{nucmerr}{Mutation information containing group list(derived from "nucmer" object using "nucmerRMD" function).}

\item{gff3}{"GFF3" format gene position data for SARS-Cov-2(the "GFF3" file should include columns named: "Gene", "Start", "Stop").}

\item{figurelist}{Whether to output the integrated plot list for each gene.}

\item{outdir}{The output directory, if the figurelist = TRUE, output the figure in the R session.}
}
\value{
Plot the mutation counts figure for each gene as output.
}
\description{
After annotating the mutations, this function is to plot the counts of mutational events for
each gene in the SARS-CoV-2 genome.
}
\examples{
data("nucmerr")
data("gene_position")
#outdir <- tempdir()
MutByGene(nucmerr = nucmerr, gff3 = gene_position, figurelist = FALSE, outdir = NULL)
#if figurelist = TRUE, the recommendation for figure display(in pixel)is: width=1650, height=1300
}
