% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalSNPprofile.R
\name{globalSNPprofile}
\alias{globalSNPprofile}
\title{Global single nucleotide polymorphism (SNP) profiling in virus genome}
\usage{
globalSNPprofile(
  nucmerr = nucmerr,
  outdir = NULL,
  figure_Type = "heatmap",
  country = "global",
  top = 5
)
}
\arguments{
\item{nucmerr}{Mutation information containing group list(derived from "nucmer" object using "nucmerRMD" function).}

\item{outdir}{The output directory.}

\item{figure_Type}{Figure type for either "heatmap" or "count".}

\item{country}{Choose a country to plot the mutational pattern or
choose "global" to profile mutations across all countries. The
default is "global".}

\item{top}{The number of mutational classes to plot.}
}
\value{
Plot the selected figure type as output.
}
\description{
This function is to visualize the global SNP pattern in the
SARS-CoV-2 genome.
}
\examples{
data("nucmerr")
outdir <- tempdir()
globalSNPprofile(nucmerr = nucmerr,
                 outdir = outdir,
                 figure_Type = "heatmap",
                 country = "global",
                 top = 5)
}
