% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indelSNP.R
\name{indelSNP}
\alias{indelSNP}
\title{Provide effects of each single nucleotide polymorphism (SNP), insertion and deletion in virus genome}
\usage{
indelSNP(
  nucmer = nucmer,
  saveRda = FALSE,
  refseq = refseq,
  gff3 = gff3,
  annot = annot,
  outdir = NULL
)
}
\arguments{
\item{nucmer}{An object called "nucmer", mutation information derived
from "nucmer.snp" variant file by "seqkit" software and "nucmer
SNP-calling" scripts. To be processed by "indelSNP" function, The nucmer
object should be first transformed by "mergeEvents" function.}

\item{saveRda}{Whether to save the results as ".rda" file.}

\item{refseq}{SARS-Cov-2 genomic reference sequence.}

\item{gff3}{"GFF3" format annotation data for SARS-Cov-2.}

\item{annot}{Annotation of genes(corresponding proteins) list from "GFF3" file by "setNames(gff3[,10],gff3[,9])".}

\item{outdir}{The output directory.}
}
\value{
Write the result as ".csv" file to the specified directory.
}
\description{
This function is to annotate the mutational events and indicate their potential effects on the proteins.
Mutational events include SNP, insertion and deletion.
}
\examples{
data("nucmer")
# Fix IUPAC codes
nucmer<-nucmer[!nucmer$qvar\%in\%c("B","D","H","K","M","N","R","S","V","W","Y"),]
nucmer<- mergeEvents(nucmer = nucmer)## This will update the nucmer object
data("refseq")
data("gff3")
annot <- setNames(gff3[,10],gff3[,9])
#outdir <- tempdir()
nucmer<- indelSNP(nucmer = nucmer,
                  saveRda = FALSE,
                  refseq = refseq,
                  gff3 = gff3,
                  annot = annot,
                  outdir = NULL)
}
