% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ammi_analysis.R
\name{perform_ammi_single_trait}
\alias{perform_ammi_single_trait}
\title{Perform AMMI Analysis for a Single Trait}
\usage{
perform_ammi_single_trait(data, env_col, gen_col, rep_col, trait_col)
}
\arguments{
\item{data}{A data frame containing the dataset with required columns.}

\item{env_col}{Character. Name of the environment column.}

\item{gen_col}{Character. Name of the genotype column.}

\item{rep_col}{Character. Name of the replication column.}

\item{trait_col}{Character. Name of the trait column to be analyzed.}
}
\value{
A list containing:
\itemize{
  \item `analysis`: The AMMI analysis results.
  \item `biplot`: The biplot (PC1 vs PC2).
  \item `pc1_plot`: The PC1 vs Trait plot.
}
}
\description{
This function performs Additive Main Effects and Multiplicative Interaction (AMMI) analysis
for a single trait to evaluate genotype x environment interactions. It generates biplots
and PC1 vs. Trait visualizations without relying on predictions.
}
\examples{
\donttest{
set.seed(123)
data <- data.frame(
  GEN = rep(c("G1", "G2", "G3", "G4"), each = 12),
  ENV = rep(c("E1", "E2", "E3"), each = 4, times = 4),
  REP = rep(1:3, times = 16),
  Y = c(rnorm(12, 50, 5), rnorm(12, 55, 5), rnorm(12, 60, 5), rnorm(12, 65, 5))
)
results <- perform_ammi_single_trait(data, "ENV", "GEN", "REP", "Y")
}
}
