% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossExpression.R
\name{bullseye_plot}
\alias{bullseye_plot}
\title{Outputs a circular bullseye plot for a gene pair.
The central circle is gene B in cells expressing gene A.
Rings indicate neighbors with gene B, where the first ring is the first neighbor.}
\usage{
bullseye_plot(scores)
}
\arguments{
\item{scores}{Bullseye score as a vector.}
}
\value{
Returns a circular bullseye plot.
}
\description{
Outputs a circular bullseye plot for a gene pair.
The central circle is gene B in cells expressing gene A.
Rings indicate neighbors with gene B, where the first ring is the first neighbor.
}
\examples{
data("locations")
data("expression")
locations  = as.matrix(locations)
expression = as.matrix(expression)
expression = expression[,1:5]
results    = bullseye_scores(data = expression, locations = locations)
results    = as.numeric(results[1, 3:ncol(results)]) # choose gene pair of interest (row index)
bullseye_plot(results)

}
