% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csp_cost_functions.R
\name{add_geometry}
\alias{add_geometry}
\title{Add geometric features to a LAS object}
\usage{
add_geometry(las, k = 10L, n_cores = 1)
}
\arguments{
\item{las}{A LAS object (see lidR::LAS)}

\item{k}{the k nearest neighbors to use for the eigenvalue calculation}

\item{n_cores}{The number of CPU cores to use}
}
\value{
The function returns a single LAS object with the geometric features
attached to it in the LAS@data section.
}
\description{
The function calls a fast cpp multi-core function to calculate eigenvalues
for the points in a point cloud based on the k nearest neighbors. Afterwards
it adds geometric features like Curvature, Linearity, Planarity, Sphericity,
Anisotrophy and Verticlity to the points itself.
}
\details{
Details of the metrics can be found in: Hackel, T., Wegner, J.D. &
Schindler, K. (2016) Contour Detection in Unstructured 3D Point Clouds. In
2016 IEEE Conference on Computer Vision and Pattern Recognition (CVPR).
Presented at the 2016 IEEE Conference on Computer Vision and Pattern
Recognition (CVPR), IEEE, Las Vegas, NV, USA, pp. 1610-1618.
}
\examples{
\donttest{
LASfile <- system.file("extdata", "beech.las", package="CspStandSegmentation")
las <- lidR::readLAS(LASfile, select = "xyz")

las <- add_geometry(las, k = 5, n_cores = 2)
summary(las@data)
}

}
\author{
Julian Frey <julian.frey@wwd.uni-freiburg.de>
}
