#' NSF SUCCESS Engineering Curricula Networks
#'
#' A collection of curricular networks for five engineering disciplines across
#' multiple MIDFIELD institutions in the United States. Each network is an
#' \code{igraph} object representing courses as nodes and prerequisite/corequisite
#' relationships as directed edges.
#'
#' @details
#' Context: These curricula are from institutions in the Multiple-Institution
#' Database for Engineering Longitudinal Development (MIDFIELD), which contains
#' nearly two million undergraduate student records from 21 U.S. universities
#' spanning 1987-2024. This dataset complements MIDFIELD by capturing curricular
#' structure and complexity as part of the project "Studying Undergraduate
#' Curricular Complexity for Engineering Student Success (SUCCESS)."
#'
#' Sampling: Curricular plans were collected from 13 MIDFIELD institutions
#' over 10 years for Mechanical, Electrical, Chemical, Civil, and Industrial
#' Engineering programs using institutional websites and the Internet Archive
#' Wayback Machine.
#'
#' Data structure: The dataset is a list of 494 \code{igraph} objects. Each object
#' corresponds to a plan of study for a specific discipline, institution, and
#' year. Vertices represent courses with attributes \code{course_name},
#' \code{course_code}, \code{term}, \code{credits}, and \code{notes}. Edges represent
#' prerequisite and corequisite relationships with attribute \code{type}
#' ("prereq" or "coreq").
#'
#' Limitations: The dataset focuses on large, research-intensive institutions
#' and five engineering disciplines. Users should exercise caution when
#' extrapolating beyond this scope. Minor data entry errors may exist for older
#' plans of study, but overall trends are robust.
#'
#' @format A list of 494 \code{igraph} objects.
#'
#' @source Collected from institutional websites and the Internet Archive Wayback
#' Machine, Fall 2022.
#'
#' @references
#' Reeping, D., Padhye, S. M., & Rashedi, N. (2023). A process for systematically
#' collecting plan of study data for curricular analytics. In \emph{Proceedings of
#' the 2023 ASEE Annual Conference & Exposition}.
#'
#' Padhye, S., Reeping, D., & Rashedi, N. (2024). Analyzing trends in curricular
#' complexity and extracting common curricular design patterns. In
#' \emph{Proceedings of the 2024 ASEE Annual Conference & Exposition}.
#'
#' Reeping, D., Ebrahiminejad, H., Ohland, M., Reid, K., & Rashedi, N. (2026).
#' Analyzing the curricular complexity of engineering programs across disciplines
#' and time. \emph{IEEE Transactions on Education}.
#'
#' #' Rashedi, N., Reeping, D., Wei, S. (2026).
#' A scoping review of methods used to analyze engineering curricula quantitatively
#' using curricular analytics \emph{Engineering Education Review}.
#'
#' @docType data
#' @keywords datasets
"NSF_SUCCESS"
