% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session_to_nest.R
\name{df_to_nest}
\alias{df_to_nest}
\title{Transform a dataframe to a nested lists structure (i.e. hierarchical).}
\usage{
df_to_nest(data, step_cols, nodes_data = NULL, count_col = "value",
  value_cols = NULL, agg_function = sum, na_behavior = "rm")
}
\arguments{
\item{data}{The data frame to convert to the nested structure. It needs to have several comlumns, each ones account for a given step}

\item{step_cols}{vector containing the names of the columns which should be used as steps. The vector should be ordered. ex: c('step1','step2','step3')}

\item{nodes_data}{A named list to add addition informations to each nodes}

\item{count_col}{Number of occurences in this path (succesion of steps). Default: NULL}

\item{value_cols}{Names of the other columns to keep. Default: NULL}

\item{agg_function}{aggregation function to be applied to value_cols.Ex: mean, sum. Default: sum. Weighted version can also be used, the weighting will be done using the counting variable}

\item{na_behavior}{How to deal with missing data ?}
}
\value{
A data.table with the columns specified in count_col, value_cols and one column per step in the path
}
\description{
Transform a dataframe to a nested lists structure (i.e. hierarchical).
}
