% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_CombineAssignOutput.R
\name{combine_assign_output}
\alias{combine_assign_output}
\title{Combine Taxa Assignment for Same ASV Using Different Databases}
\usage{
combine_assign_output(fileLoc = NULL, numCores = 1, verbose = TRUE)
}
\arguments{
\item{fileLoc}{The location of a file in a directory where all of the 'taxaAssign'
files are located (Default NULL).}

\item{numCores}{The number of cores used to run the function (Default 1,
Windows systems can only use a single core)}

\item{verbose}{If set to TRUE then there will be output to the R console, if
FALSE then this reporting data is suppressed (Default TRUE).}
}
\value{
This function produces a 'YYYY_MM_DD_HHMM_taxaAssignCombined.tsv' and
a 'YYYY_MM_DD_HHMM_taxaAssignCombined.txt' file in the selected target
directory.
}
\description{
This function takes a file selection and then uses all 'taxaAssign' files in
that directory and combines them into a single output
'taxaAssignCombined.tsv' file.
}
\details{
The User Input: This function requires a file in a directory where all 'taxaAssign'
files in that directory will be combined.

The examples are present to display the syntax for the function.
These examples are not run because there are files required to run the functions,
in some cases multiple files are necessary and some of these are quite large. To
get specific examples please see https://github.com/rgyoung6/DBTCShinyTutorial/blob/main/README.md
}
\note{
WARNING - NO WHITESPACE!

When running DBTC functions the paths for the files selected cannot have white
space! File folder locations should be as short as possible (close to the root
as some functions do not process long naming conventions.

Also, special characters should be avoided (including question mark, number
sign, exclamation mark). It is recommended that dashes be used for separations
in naming conventions while retaining underscores for use as information
delimiters (this is how DBTC functions use underscore).

There are several key character strings used in the DBTC pipeline, the presence
of these strings in file or folder names will cause errors when running DBTC functions.

The following strings are those used in DBTC and should not be used in file or folder naming:
- _BLAST
- _combinedDada
- _taxaAssign
- _taxaAssignCombined
- _taxaReduced
- _CombineTaxaReduced
}
\examples{
\dontrun{
combine_assign_output()
combine_assign_output(fileLoc = NULL,   numCores = 1)
}

}
\references{
<https://github.com/rgyoung6/DBTC>
Young, R. G., Hanner, R. H. (Submitted October 2023). Dada-BLAST-Taxon Assign-Condense
Shiny Application (DBTCShiny). Biodiversity Data Journal.
}
\seealso{
dada_implement()
combine_dada_output()
make_BLAST_DB()
seq_BLAST()
taxon_assign()
reduce_taxa()
combine_reduced_output()
}
\author{
Robert G. Young
}
