% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggb.R
\name{ggbgetAgesFit}
\alias{ggbgetAgesFit}
\title{determine the age range that minimizes the mean squared error}
\usage{
ggbgetAgesFit(codi, minA = 15, maxA = 75, minAges = 8,
  deaths.summed = FALSE)
}
\arguments{
\item{codi}{a chunk of data (single sex, year, region, etc) with all columns required by \code{ggb()}}

\item{minA}{the lowest age to be included in search}

\item{maxA}{the highest age to be included in search (the lower bound thereof)}

\item{minAges}{the minimum number of adjacent ages to be used in estimating}

\item{deaths.summed}{logical. is the deaths column given as the total per age in the intercensal period (\code{TRUE}). By default we assume \code{FALSE}, i.e. that the average annual was given.}
}
\value{
a vector of ages that minimizes the RMSE
}
\description{
Called by \code{ggbcoverageFromYear()} whenever \code{exact.ages} are not given. This automates what one typically does visually.
}
\seealso{
code{\link{ggbChooseAges}}
}
