% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEMAP.R
\name{DEMAP}
\alias{DEMAP}
\title{DEMAP}
\usage{
DEMAP(LogPostLike, control_params = AlgoParamsDEMAP(), ...)
}
\arguments{
\item{LogPostLike}{function whose first argument is an n_params-dimensional model parameter vector and returns (scalar) sum of log prior density and log likelihood for the parameter vector.}

\item{control_params}{control parameters for DE algorithm. see \code{\link{AlgoParamsDEMAP}} function documentation for more details.}

\item{...}{additional arguments to pass LogPostLike}
}
\value{
list contain posterior samples from DEMCMC in a n_iters_per_chain by n_chains by n_params array and the log likelihood of each sample in a n_iters_per_chain by n_chains array.
}
\description{
DE optimization for maximum a posteriori (MAP) estimation; his function tries to find the posterior mode.
}
\examples{
# simulate from model
dataExample <- matrix(stats::rnorm(100, c(-1, 1), c(1, 1)), nrow = 50, ncol = 2, byrow = TRUE)

# list parameter names
param_names_example <- c("mu_1", "mu_2")

# log posterior likelihood function = log likelihood + log prior | returns a scalar
LogPostLikeExample <- function(x, data, param_names) {
  out <- 0

  names(x) <- param_names

  # log prior
  out <- out + sum(dnorm(x["mu_1"], 0, sd = 1, log = TRUE))
  out <- out + sum(dnorm(x["mu_2"], 0, sd = 1, log = TRUE))

  # log likelihoods
  out <- out + sum(dnorm(data[, 1], x["mu_1"], sd = 1, log = TRUE))
  out <- out + sum(dnorm(data[, 2], x["mu_2"], sd = 1, log = TRUE))

  return(out)
}

# Get map estimates
DEMAP(
  LogPostLike = LogPostLikeExample,
  control_params = AlgoParamsDEMAP(
    n_params = length(param_names_example),
    n_iter = 1000,
    n_chains = 12
  ),
  data = dataExample,
  param_names = param_names_example
)

}
