% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiFunctions.R
\docType{class}
\name{DexiDiscretizeFunction-class}
\alias{DexiDiscretizeFunction-class}
\alias{DexiDiscretizeFunction}
\title{DexiDiscretizeFunction}
\description{
\code{DexiDiscretizeFunction} is a RC class, derived from \link{DexiFunction}.
Functions of this type discretize numerical values of continuous attributes to qualitative
values of discrete attributes. More precisely, a \code{DexiDiscretizeFunction} can be defined
only for a discrete attribute that has exactly one continuous input. Then, the function discretizes
numeric values of the input attribute and maps them to discrete values of the parent attribute.
}
\details{
Objects of class \code{DexiDiscretizeFunction}  define discretization rules in terms of three lists:
\code{values}, \code{bounds} and \code{assoc}. Using \code{n <- nvals()} to denote the length of
\code{values}, the required lengths of \code{bounds} and \code{assoc} are \code{n - 1}.

The list \code{bounds} refers to values of the input attribute and partitions its scale in \code{n} intervals
\verb{[-Inf, bound[[1]]]}, \verb{[bound[[1]], bound[[2]]],} ..., \verb{[bound[[n - 1]]], +Inf]}.
The list \code{values} then defines the output values for each interval.
The list \code{assoc} contains strings \code{"up"} or \code{"down"} that indicate to which interval,
lower or higher, belong the corresponding \code{bounds}.
}
\section{Fields}{

\describe{
\item{\code{attribute}}{\link{DexiAttribute}. The attribute this function is associated with.
Requirements: \code{attribute} must be discrete (i.e., associated with a \link{DexiDiscreteScale}) and
must have exactly one continuous input attribute (i.e., associated with a \link{DexiContinuousScale}).}

\item{\code{values}}{A list of output values corresponding to each interval defined by \code{bounds}.
List elements are in general value sets, i.e., integer vectors of value indices w.r.t. \code{attribute$scale}.}

\item{\code{bounds}}{A vector of numeric values that partitions the input scale in intervals.}

\item{\code{assoc}}{A vector of strings \code{"up"} or \code{"down"}.
For each \verb{i in 1:n-1}, \code{assoc[[i]]} indicates how to map the value of
\code{bounds[[i]]}: to \code{value[[i]]} (\code{"down"}) or \code{value[[i + 1]]} (\code{"up"}).}
}}

\section{Methods}{

\describe{
\item{\code{bound_assoc(idx, default = "down")}}{Given \code{idx}, a \code{bounds} index, return the corresponing association
(\code{"down"} or \code{"up"}).}

\item{\code{evaluate(x)}}{A silent wrapper around \code{value(x)}; it returns \code{NULL} when
\code{value(x)} fails with an error.}

\item{\code{nargs()}}{Return the number of function arguments.}

\item{\code{nvals()}}{Return the length of \code{values}.}

\item{\code{to_string()}}{Return an informative string about this function's \code{values} and \code{bounds}.}

\item{\code{value(x)}}{Return the function value for arguments \code{x}, where arguments are
a numeric vector of length equal to \code{att$inputs}.
Additionally, arguments of a \code{DexiTabularFunctions$value()} must be integer numbers,
and the argument of \code{DexiDiscretizeFunctions$value()} must be a single number.}

\item{\code{verify()}}{Check the correctnes of this function object and its fields.
Result: \code{error()} or \code{TRUE}.}
}}

\examples{
# Create a DexiDiscretizeFunction (without association to any attributes or scales)
fnc <- DexiDiscretizeFunction(bounds = c(-1, 2), values = list(1, 3, 5), assoc = c("up", "down"))

# Print fields and basic properties of fnc

fnc$verify()
fnc$nargs()
fnc$nvals()
fnc$to_string()

fnc$bound_assoc(1)
fnc$bound_assoc(2)

# Try some discretizations
sapply(c(-1.1, -1, 0, 1, 2, 3), fnc$evaluate)

}
