% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiUtils.R
\name{is_in_range}
\alias{is_in_range}
\title{is_in_range}
\usage{
is_in_range(x, lb, hb, lassoc = c("up", "down"), hassoc = c("down", "up"))
}
\arguments{
\item{x}{Any object type, but using a non-numeric argument always returns \code{FALSE}.}

\item{lb}{\code{numeric(1)}. Lower bound of the interval.}

\item{hb}{\code{numeric(1)}. Ipper bound of the interval.}

\item{lassoc}{\code{"up"} or \code{"down"}, indicating whether \code{lb} is included
in the \verb{[lb:hb]} interval (\code{"up"}) or not (\code{"down"}). The default is \code{"up"}.}

\item{hassoc}{\code{"up"} or \code{"down"}, indicating whether \code{hb} is included
in the \verb{[lb:hb]} interval (\code{"down"}) or not (\code{"up"}). The default is \code{"down"}.}
}
\value{
\code{logical(1)}, indicating whether or not \code{x} lies in the interval \verb{[lb:hb]}
according to function arguments.
}
\description{
Check whether or not \code{x} lies the specified range.
}
\examples{
is_in_range(3, 2, 5)
is_in_range(7, 2, 5)
is_in_range(3, 3, 5)
is_in_range(3, 3, 5, lassoc = "down")

}
