% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_tools.R
\name{extractCoverageFromTxt}
\alias{extractCoverageFromTxt}
\title{Extract read counts from plain text file}
\usage{
extractCoverageFromTxt(refFileName, altFileName)
}
\arguments{
\item{refFileName}{Path of the reference allele count file.}

\item{altFileName}{Path of the alternative allele count file.}
}
\value{
A data.frame contains four columns: chromosomes, positions, reference allele count, alternative allele count.
}
\description{
Extract read counts from tab-delimited text files of a single sample.
}
\note{
The allele count files must be tab-delimited. The allele count files contain three columns: chromosomes, positions and allele count.
}
\examples{
refFile <- system.file("extdata", "PG0390-C.test.ref", package = "DEploid.utils")
altFile <- system.file("extdata", "PG0390-C.test.alt", package = "DEploid.utils")
PG0390 <- extractCoverageFromTxt(refFile, altFile)

}
