% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveDampenedWLSj.R
\name{solveDampenedWLSj}
\alias{solveDampenedWLSj}
\title{solveDampenedWLSj}
\usage{
solveDampenedWLSj(S, B, goldStandard, j)
}
\arguments{
\item{S}{List output from trimData$sig (S)}

\item{B}{List output from trimData$bulk (B)}

\item{goldStandard}{Starting point for the weights, this can be determined
using solveOLSInternal(S,B)}

\item{j}{The dampening constant, this can be determined using
findDampeningConstant(S,B,goldStandard)}
}
\value{
value (Dampened weighted least squares estimation values)
}
\description{
Solve dampened weighted least squares given a dampening constant.

Note: The function uses solveDampenedWLS() and findDampeningConstant().
}
\examples{
\donttest{
#Sig
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/Sig.RData"
#dest <- "data/Sig.RData"
#download.file(url, dest)
#load("data/Sig.RData")
load(system.file("extdata", "Sig.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#download.file(url, dest)
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

trimmed <- trimData(Sig, dataBulk)
S <- trimmed$sig
B <- trimmed$bulk
solution <- solveOLSInternal(S,B)
j <- findDampeningConstant(S,B,solution)
goldStandard <- solveOLSInternal(S,B)
solveDampenedWLSj(S,B,goldStandard,j)
}
}
