% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimData.R
\name{trimData}
\alias{trimData}
\title{trimData}
\usage{
trimData(Signature_Matrix, bulkdata)
}
\arguments{
\item{Signature_Matrix}{A single-cell signature matrix}

\item{bulkdata}{A bulk dataset}
}
\value{
A list of trimmed bulk and single-cell data.
}
\description{
This function trims bulk and single-cell data to
contain the same genes. The result is a list of the intersecting genes
within the two datasets.
}
\examples{
 \donttest{
#Sig
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/Sig.RData"
#dest <- "data/Sig.RData"
#download.file(url, dest)
#load("data/Sig.RData")
load(system.file("extdata", "Sig.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#download.file(url, dest)
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

trimData(Signature_Matrix = Sig, bulkdata = dataBulk)
}
}
