% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeRezende.Ferreira.5F.R
\name{DRF.5F.tVar}
\alias{DRF.5F.tVar}
\title{Estimation of the De Rezende-Ferreira 5 Factor model's parameters with variable \eqn{\ \tau}}
\usage{
DRF.5F.tVar(rate, maturity)
}
\arguments{
\item{rate}{Vector or matrix of class "zoo", which contains interest rates}

\item{maturity}{Vector of class "numeric", wich contains the maturities \cr}
}
\value{
An object of class "zoo", that contains
\eqn{\ \left (\beta_{0t},\ \beta_{1t},\ \beta_{2t},\ \beta_{3t},\ \beta_{4t},\ \tau_{1t},\ \tau_{2t},\ SSR_{t},\ R^{2}_{t} \right)}
}
\description{
The command estimates the parameters of the De Rezende-Ferreira 5 Factor model
             using variable \eqn{\ \tau_{1}} and \eqn{\ \tau_{2}}
}
\details{
The De Rezende-Ferreira model used to fit the forward rates is: \cr

\deqn{f_{t}\left(m\right) = \beta_{0t} +
\beta_{1t} e^{-\frac{m}{\tau_{1t}}} + \beta_{2t} e^{-\frac{m}{\tau_{2t}}} +
\beta_{3t} \left ( {\frac{m}{\tau_{1t}}} e^{-\frac{m}{\tau_{1t}}}  \right ) +
\beta_{4t} \left ( {\frac{m}{\tau_{2t}}} e^{-\frac{m}{\tau_{2t}}}  \right )} \cr


The spot rates, derived from the forward rates \eqn{f_{t}\left(m\right)}, are given by: \cr

\deqn{y_{t}\left ( m \right ) = \beta_{0t} +
\beta_{1t} \left (\frac{1 - e^{-\frac{m}{\tau_{1t}}}}{\frac{m}{\tau_{1t}}}\right) +
\beta_{2t} \left (\frac{1 - e^{-\frac{m}{\tau_{2t}}}}{\frac{m}{\tau_{2t}}}\right) +
\beta_{3t} \left (\frac{1 - e^{-\frac{m}{\tau_{1t}}}}{\frac{m}{\tau_{1t}}} - e^{-\frac{m}{\tau_{1t}}}\right ) +
\beta_{4t} \left (\frac{1 - e^{-\frac{m}{\tau_{2t}}}}{\frac{m}{\tau_{2t}}} - e^{-\frac{m}{\tau_{2t}}}\right )}\cr


The set of optimal parameters will be chosen according to the lowest RMSE value:\cr

  \deqn{\left (\widehat{\tau}_{1t},\widehat{\tau}_{2t} \right) = argmin\left \{\frac{1}{N}\sum_{t=1}^{N}
  \sqrt{\frac{1}{T}\sum_{t=1}^{T}\left [ y_{t}\left (t_{n} \right ) - \widehat{y}_{t}\left  (t_{n},\tau_{1t},
  \tau_{2t},\widehat{\beta_{t}}\right )\right ]^{2} } \right \}}\cr
}
\examples{
#
# De Rezende-Ferreira 5F model on the Brazilian Data-Set
#

data(ZC_Brazil)
real.rate = ZC_Brazil

ZC_Brazil[["Date"]] = NULL

rate = zoo(ZC_Brazil)
index(rate) = as.POSIXct(paste(real.rate[["Date"]]))
maturity <- c(0.5, 0.75, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)

RF.5F.Parameters <- DRF.5F.tVar(rate, maturity)

par(mfrow=c(3,2))
 plot(RF.5F.Parameters[,"beta0"],xlab="Date",ylab="BETA0",ylim=c(9.5,12.0),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta1"],xlab="Date",ylab="BETA1",ylim=c(-18.0,2.3),col= "blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta2"],xlab="Date",ylab="BETA2",ylim=c(-6.0,13.0),col= "blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta3"],xlab="Date",ylab="BETA3",ylim=c(-10.0,0.0),col= "blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta4"],xlab="Date",ylab="BETA4",ylim=c(-5.0,5.0),col="blue",lwd=1)
 grid(nx=12, ny=12)
par(mfrow=c(1,1))

par(mfrow=c(2,1))
 plot(RF.5F.Parameters[,"tau1"],xlab="Date",ylab="TAU1",ylim=c(0.2,1.3),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"tau2"],xlab="Date",ylab="TAU2",ylim=c(2.5,5.5),col="blue",lwd=1)
 grid(nx=12, ny=12)
par(mfrow=c(1,1))

#
# De Rezende-Ferreira 5F on the Russian Data-Set
#

data(ZC_Russia)
real.rate = ZC_Russia

ZC_Russia[["Date"]] = NULL

rate = zoo(ZC_Russia)
index(rate) = as.POSIXct(paste(real.rate[["Date"]]))
maturity <- c(0.25, 0.5, 0.75, 1,2,3,5,7,10,15,20,30)
RF.5F.Parameters <- DRF.5F.tVar(rate, maturity)

par(mfrow=c(3,2))
 plot(RF.5F.Parameters[,"beta0"],xlab="",ylab="BETA0",ylim=c(10.5,12.5),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta1"],xlab="Date",ylab="BETA1",ylim=c(-1.5,0.5),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta2"],xlab="Date",ylab="BETA2",ylim=c(-7.0,-3.5),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta3"],xlab="Date",ylab="BETA3",ylim=c(-1.5,3.5),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"beta4"],xlab="Date",ylab="BETA4",ylim=c(-5.5,-0.1),col="blue",lwd=1)
 grid(nx=12, ny=12)
par(mfrow=c(1,1))


par(mfrow=c(2,1))
 plot(RF.5F.Parameters[,"tau1"],xlab="Date",ylab="TAU1",ylim=c(0.1,1.9),col="blue",lwd=1)
 grid(nx=12, ny=12)
 plot(RF.5F.Parameters[,"tau2"],xlab="Date",ylab="TAU2",ylim=c(7.5,16.8),col="blue",lwd=1)
 grid(nx=12, ny=12)
par(mfrow=c(1,1))

}
