% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSSMod.R
\name{summary.DiSSMod}
\alias{summary.DiSSMod}
\alias{print.summary.DiSSMod}
\title{Summarizing Discrete Sample Selection Model Fits}
\usage{
\method{summary}{DiSSMod}(object, ...)

\method{print}{summary.DiSSMod}(x, digits = max(3, getOption("digits") -
  3), ...)
}
\arguments{
\item{object}{an object of class \code{"DiSSMod"} made by the function \code{DiSSMod}.}

\item{\dots}{additional control argument is as follows.
\itemize{
\item \code{level}: an option for controlling the significance level of confidence interval.
It has to be given in probability between 0 and 1. Initial level is set to \eqn{1 - \alpha = 0.95}.
}}

\item{x}{an object of class \code{"summary.DiSSMod"}.}

\item{digits}{a numeric number of significant digits.}
}
\value{
The function \code{summary.DiSSMod} returns a list of summary statistics of the fitted
discrete sample selection model given in \code{object}.

The components, which are not duplicated from the \code{object}, are as follows:

\item{z.value_response}{Z statistics (normal distribution) for coefficients of response equation.}
\item{z.value_selection}{Z statistics (normal distribution) for coefficients of selection equation.}
\item{CI_alpha}{confidence interval of the parameter \code{alpha}.}
\item{level}{a numeric value between 0 and 1 for controlling the significance level of confidence interval.
 Initial level is set to \eqn{1 - \alpha = 0.95}.}
}
\description{
\code{summary} method for a class \code{"DiSSMod"}.
}
\details{
If \code{standard} equals \code{TRUE}, \code{summary} also additionally returns summary
statistics of standardized results. Otherwise, it just returns summary statistics as similar statistics
as the generic function \code{summary}.
}
\examples{
# example continued from DiSSMod
set.seed(45)
data(DoctorRWM, package = "DiSSMod")
n0 <- 600
set.n0 <- sample(1:nrow(DoctorRWM), n0)
reduce_DoctorRWM <- DoctorRWM[set.n0,]
result0 <- DiSSMod(response = as.numeric(DOCVIS > 0) ~ AGE + INCOME_SCALE + HHKIDS + EDUC + MARRIED,
                   selection = PUBLIC ~ AGE + EDUC + FEMALE,
                   data = reduce_DoctorRWM, resp.dist="bernoulli", select.dist = "normal",
                   alpha = seq(-5.5, -0.5, length.out = 21), standard = TRUE)

summary(result0, level = 0.90)

data(CreditMDR, package = "DiSSMod")
n1 <- 600
set.n1 <- sample(1:nrow(CreditMDR), n1)
reduce_CreditMDR <- CreditMDR[set.n1,]
result1 <- DiSSMod(response = MAJORDRG ~ AGE + INCOME + EXP_INC,
                   selection = CARDHLDR ~ AGE + INCOME + OWNRENT + ADEPCNT + SELFEMPL,
                   data = reduce_CreditMDR, resp.dist="poi", select.dist = "logis",
                   alpha = seq(-0.3, 0.3,length.out = 21), standard = FALSE, verbose = 1)

summary(result1)

}
\seealso{
See also \code{\link{DiSSMod}} and \code{\link[base]{summary}}.
}
