% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sptd.R
\name{sptd}
\alias{sptd}
\title{Sparse Temporal Disaggregation}
\usage{
sptd(Y, X, rho, aggMat = "sum", aggRatio = 4, adaptive = FALSE)
}
\arguments{
\item{Y}{The low-frequency response series (\eqn{n_l \times 1} matrix).}

\item{X}{The high-frequency indicator series (\eqn{n \times p} matrix).}

\item{rho}{The AR(\eqn{1}) residual parameter (must be strictly between \eqn{-1} and \eqn{1}).}

\item{aggMat}{Aggregation matrix method ('first', 'sum', 'average', 'last'). Default is 'sum'.}

\item{aggRatio}{Aggregation ratio (e.g., 4 for annual-to-quarterly, 3 for quarterly-to-monthly). Default is 4.}

\item{adaptive}{Logical. If \code{TRUE}, use adaptive LASSO penalty. If \code{FALSE}, use standard LASSO penalty. Default is \code{FALSE}.}
}
\value{
A list containing:
\itemize{
\item \code{y}: Estimated high-frequency response series (\eqn{n \times 1} matrix).
\item \code{betaHat}: Estimated coefficient vector (\eqn{p \times 1} matrix).
\item \code{u_l}: Estimated aggregate residual series (\eqn{n_l \times 1} matrix).
}
}
\description{
This function performs sparse temporal disaggregation as described in \insertCite{10.1111/rssa.12952;textual}{DisaggregateTS}.
It estimates the high-frequency response series using LARS (Least Angle Regression) and applies either a LASSO or adaptive LASSO penalty.
}
\references{
\insertAllCited{}
}
\keyword{internal}
