\name{plot_sentiment_distribution}
\alias{plot_sentiment_distribution}

\title{
Plot Sentiment Distribution
}
\description{
This function Creates various plots showing sentiment distribution.
}
\usage{
plot_sentiment_distribution(data, plot_type = "bar")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
A data frame with sentiment analysis results
}
  \item{plot_type}{
Type of plot: "pie", "bar", "histogram", or "geographic"
}
}

\value{
ggplot object or plot.
}

\author{
Hossein Hassani and Leila Marvian Mashhad and Nadejda Komendantova.
}

\examples{
sample_data <- data.frame(
  sentiment_score    = c( 2.5, -1.0,  0.0,  3.0, -2.0,  1.5, -0.7),
  sentiment_category = c("Positive", "Negative", "Neutral", "Positive", 
                         "Negative", "Positive", "Neutral"),
  Longitude          = c(10.0, 11.5, 10.0, 12.2, 11.5, 10.8, 12.0),
  Latitude           = c(50.1, 49.9, 50.1, 50.5, 49.9, 50.3, 50.4),
  stringsAsFactors   = FALSE
)

bar_plot <- plot_sentiment_distribution(sample_data, plot_type = "bar")
print(bar_plot)

hist_plot <- plot_sentiment_distribution(sample_data, plot_type = "histogram")
print(hist_plot)

plot_sentiment_distribution(sample_data, plot_type = "pie")

geo_plot <- plot_sentiment_distribution(sample_data, plot_type = "geographic")
print(geo_plot)
}
