% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IG.R
\name{IG}
\alias{IG}
\alias{expValIG}
\alias{varIG}
\alias{expValLimIG}
\alias{expValTruncIG}
\alias{stopLossIG}
\alias{meanExcessIG}
\alias{VatRIG}
\alias{TVatRIG}
\alias{mgfIG}
\title{Inverse Gaussian Distribution}
\usage{
expValIG(mean, shape = dispersion * mean^2, dispersion = shape/mean^2)

varIG(mean, shape = dispersion * mean^2, dispersion = shape/mean^2)

expValLimIG(d, mean, shape = dispersion * mean^2, dispersion = shape/mean^2)

expValTruncIG(
  d,
  mean,
  shape = dispersion * mean^2,
  dispersion = shape/mean^2,
  less.than.d = TRUE
)

stopLossIG(d, mean, shape = dispersion * mean^2, dispersion = shape/mean^2)

meanExcessIG(d, mean, shape = dispersion * mean^2, dispersion = shape/mean^2)

VatRIG(kap, mean, shape = dispersion * mean^2, dispersion = shape/mean^2)

TVatRIG(kap, mean, shape = dispersion * mean^2, dispersion = shape/mean^2)

mgfIG(t, mean, shape = dispersion * mean^2, dispersion = shape/mean^2)
}
\arguments{
\item{mean}{mean (location) parameter \eqn{\mu}{mu}, must be positive.}

\item{shape}{shape parameter \eqn{\beta}{beta}, must be positive}

\item{dispersion}{alternative parameterization to the shape parameter, dispersion = 1 / rate.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}

\item{t}{t.}
}
\value{
Function :
  \itemize{
    \item \code{\link{expValIG}}  gives the expected value.
    \item \code{\link{varIG}}  gives the variance.
    \item \code{\link{expValLimIG}}  gives the limited mean.
    \item \code{\link{expValTruncIG}}  gives the truncated mean.
    \item \code{\link{stopLossIG}}  gives the stop-loss.
    \item \code{\link{meanExcessIG}}  gives the mean excess loss.
    \item \code{\link{VatRIG}}  gives the Value-at-Risk.
    \item \code{\link{TVatRIG}}  gives the Tail Value-at-Risk.
    \item \code{\link{mgfIG}}  gives the moment generating function (MGF).
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Inverse Gaussian distribution with mean \eqn{\mu}{mu} and shape parameter
\eqn{\beta}{beta}.
}
\details{
The Inverse Gaussian distribution with
}
\note{
Function VatRIG is a wrapper for the \code{\link[statmod]{qinvgauss}}
function from the statmod package.
}
\examples{
expValIG(mean = 2, shape = 5)

varIG(mean = 2, shape = 5)

expValLimIG(d = 2, mean = 2, shape = 5)

expValTruncIG(d = 2, mean = 2, shape = 5)

stopLossIG(d = 2, mean = 2, shape = 5)

meanExcessIG(d = 2, mean = 2, shape = 5)

VatRIG(kap = 0.99, mean = 2, shape = 5)

TVatRIG(kap = 0.99, mean = 2, shape = 5)

mgfIG(t = 1, mean = 2, shape = .5)

}
