% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics-CloudProvider.R,
%   R/method-default.R
\name{reconnectDockerCluster}
\alias{reconnectDockerCluster}
\alias{reconnectDockerCluster,ANY-method}
\title{Reconnect to the cluster}
\usage{
reconnectDockerCluster(provider, cluster, verbose)

\S4method{reconnectDockerCluster}{ANY}(provider, cluster, verbose)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
No return value
}
\description{
Reconnect to the cluster with the same job queue name. It is provider's
responsibility to recover the data in the cluster, see details. The default
method will do nothing.
}
\details{
This function is designed for reconnecting to the same cluster on the cloud
from a new \code{DockerCluster} object. Since the new object does not have the data
used by the old \code{DockerCluster} object, it is provider's responsibility to
obtain them from the cloud(Mostly from the server container).

The data for a \code{DockerCluster} object can be extracted by \code{getDockerStaticData()}
and set by \code{setDockerStaticData()}. It is recommended can extract and store the data in
the server container during the deployment process and recover the cluster data from the
server container when this function is called.
}
\section{Functions}{
\itemize{
\item \code{reconnectDockerCluster,ANY-method}: The default method, do nothing.
}}

