% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_log.R
\name{import_log}
\alias{import_log}
\title{Import \code{dynare} log file as a list of R dataframes.}
\usage{
import_log(path = ".", model = "")
}
\arguments{
\item{path}{A character string for the path to the \code{dynare} log file.}

\item{model}{Object or a character string representing the name of the \code{Dynare} model file (\code{.mod} or \code{.dyn} extension)}
}
\value{
Set of \code{Dynare} (open-source software for DSGE modelling) outputs
}
\description{
Use  this function to import \code{dynare} log file as a list of R dataframes.
The imported list can be accessed via \code{dynare$modelNmae}.
}
\examples{
\dontrun{

library(DynareR)

demo(bkk)

import_log(model="bkk")

# Alternatively, use the path to the log file

import_log(path="bkk/bkk.log")

# Access the mported list

dynare$bkk

dynare$bkk$moments

knitr::kable(dynare$bkk$decomposition,format='pandoc')
}
}
\seealso{
Other important functions: 
\code{\link{DynareR-package}},
\code{\link{add_matlab_path}()},
\code{\link{add_path}()},
\code{\link{eng_dynare}()},
\code{\link{include_IRF}()},
\code{\link{input_tex}()},
\code{\link{run_dynare}()},
\code{\link{run_models}()},
\code{\link{set_dynare_version}()},
\code{\link{set_matlab_path}()},
\code{\link{set_octave_path}()},
\code{\link{write_dyn}()},
\code{\link{write_mod}()}
}
\concept{important functions}
\keyword{documentation}
