% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECTSVR.R
\name{ECTSVR}
\alias{ECTSVR}
\title{Cointegration Based Support Vector Regression Model}
\usage{
ECTSVR(data, type = "", t, l, ker.funct = "", svm.type = "", verbose = FALSE)
}
\arguments{
\item{data}{A cointegated time series data}

\item{type}{Type of cointegration test to be used. Either "trace" or "eigen" value based}

\item{t}{Partition value for spliting the data set into training and testing}

\item{l}{Number of lags used for the support vector machine model fitting}

\item{ker.funct}{The available choices of kernel functions like radial basis, linear,   polynomial and sigmoid for fitting support vector regression. By default radial basis function works}

\item{svm.type}{SVM can be used as a regression machine. User can apply eps-regression or nu-regression. By default the ECTSVR uses eps-regression}

\item{verbose}{It is a logical parameter, represented by Boolean variables. This argument accepts either TRUE or FALSE values.}
}
\value{
Prediction performance of the ECTSVR model with outsample predition values
}
\description{
The cointegration based support vector regression model is a combination of error correction model and support vector regression (http://krishi.icar.gov.in/jspui/handle/123456789/72361). This hybrid model allows the researcher to make use of the information extracted by the cointegrating vector as an input in the support vector regression model
}
\details{
ECTSVR uses the concept of cointegration based Timedelay Neural network model proposed by Das (2019). First the cointegration of the data series is identified by Johansen cointegration test. Then error correction model is fitted for the estimation of parameters i.e. Beta and error coreection term (ECT). The estimated ECT is used as a auxiliary information in support vector regression model fitting. Then the support vector regression model is used foresting of the data series.
}
\note{
The variables in data should be cointegrated and the dependent variable should in first in data. Otherwise result will be statistically validated.
}
\examples{
data(finland)
data_example<-finland[,4:3]
ECTSVR(data_example,"trace",0.8,2, "radial","eps-regression",verbose = FALSE)

}
\references{
1. Das, P. (2019). Study On Machine Learning Techniques Based Hybrid Model for Forecasting in Agriculture. Unpublished Ph.D. Thesis. (http://krishikosh.egranth.ac.in/handle/1/5810147805).

2. Das, P., Jha,G. K. and Lama, A. (2021). An Improved Cointegration based Time Delay Neural Network Model for Price Forecasting. Journal of the Indian Society of Agricultural Statistics 75(3) 2021 187–192 (http://krishi.icar.gov.in/jspui/handle/123456789/72361)
}
\author{
Pankaj Das
}
