% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_reservation_identifiers.R
\name{list_reservation_identifiers}
\alias{list_reservation_identifiers}
\title{List reservation identifiers}
\usage{
list_reservation_identifiers(scope, env = "production")
}
\arguments{
\item{scope}{(character) Scope of data package}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(numeric) The set of identifiers for the specified \code{scope} that
end users have actively reserved for future upload
}
\description{
List reservation identifiers
}
\examples{
\dontrun{

# List reservations
reservations <- list_reservation_identifiers(scope = "edi")
reservations
#>   [1]   11  130  131  132  142  152  154  156  158  159  161  162  171
#>  [14]  172  173  174  175  177  178  180  182  183  185  196  203  ...
}
}
\seealso{
Other Identifier Reservations: 
\code{\link{create_reservation}()},
\code{\link{delete_reservation}()},
\code{\link{list_active_reservations}()}
}
\concept{Identifier Reservations}
