% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_entity_name.R
\name{read_data_entity_name}
\alias{read_data_entity_name}
\title{Read data entity name}
\usage{
read_data_entity_name(packageId, entityId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{entityId}{(character) Data entity identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character) Name of \code{entityId} in \code{packageId}
}
\description{
Read data entity name
}
\examples{
\dontrun{

# List entities
entityIds <- list_data_entities(packageId = "knb-lter-cap.691.2")
entityIds
#> [1] "f6e4efd0b04aea3860724824ca05c5dd"
#> [2] "d2263480e75cc7888b41928602cda4c6"
#> [3] "d5cb83e4556408e48f636157e4dee49e"

# Read name
entityName <- read_data_entity_name(
 packageId = "knb-lter-cap.691.2",
 entityId = entityIds[1]
)
entityName
#> [1] "691_arthropods_00742cd00ab0d3d02337e28d1c919654.csv"
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
