\name{griewank}
\alias{griewank}
\title{Griewank Function for Benchmarking Optimization Algorithms}

\usage{
griewank(x)
}

\arguments{
\item{x}{
  A numeric vector representing the input variables. The length of \code{x} determines the dimensionality of the problem.
  }
}

\value{
Returns a numeric value representing the evaluation of the Griewank function at the given input vector \code{x}.
}

\description{
The Griewank function is a common test function for optimization algorithms. It combines a sum-of-squares term and a cosine-based product term, making it a useful benchmark for exploring search space properties and assessing the performance of optimization methods on functions with numerous local minima.
}

\examples{

# Evaluation 1: Global minimum point in a four-dimensional space
x <- rep(0, 4)
griewank(x)

# Evaluation 2: A point in a six-dimensional space
x <- c(0, 0.24, 11, -1, -0.7, pi)
griewank(x)

# Contour Plot: Visualizing the Griewank Function
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) griewank(c(x, y))))
contour(x1, x2, z, nlevels = 20, main = "Contour of the Griewank Function")

# EDA.mnorm() example
res = EDA.mnorm(fun = griewank, lower = c(-10,-10), upper = c(10,10), n = 30, 
                k = 2, tolerance = 0.01, maxiter = 200)
res$sol

# Contour plot: Visualizing solution with EDA.mnorm()
x1 <- seq(-10, 10, length.out = 100)
x2 <- seq(-10, 10, length.out = 100)
z <- outer(x1, x2, FUN = Vectorize(function(x, y) griewank(c(x, y))))
contour(x1, x2, z, nlevels = 20, cex.axis = 0.8, 
        main = "Contour plot of the Griewank Function with EDA.mnorm solution")
points(res$sol[1], res$sol[2], col = "red", pch = 19)
}

\references{
Griewank, A. O. (1981). Generalized Descent for Global Optimization. \emph{Journal of Optimization Theory and Applications}, 34(1), 11–39.
}
