% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delScattering2.R
\name{delScattering2}
\alias{delScattering2}
\title{Delete scattering rays}
\usage{
delScattering2(EEM, rep = 0, first = 30, second = 40)
}
\arguments{
\item{EEM}{A list containing EEM data as created by \code{\link{readEEM}} function.}

\item{rep}{(optional) Regions to be deleted are to be replaced with \code{rep}: 0 or NA}

\item{first}{(optional) Width of region to be deleted for first order scattering rays [nm]}

\item{second}{(optional) Width of region to be deleted for second order scattering rays [nm]}
}
\value{
A list similar to input \code{EEM} is returned but with all scattering rays deleted.
}
\description{
This function deletes three regions that are not related to fluorescence emission: 
(1) regions where emission wavelength is shorten than excitation light (Em <= Ex), 
(2) scattering rays and their second order light,
(3) regions above second-order scattering (EM >= 2*EX)
}
\examples{
data(applejuice)
drawEEM(delScattering2(applejuice, NA), 1)

}
\keyword{scattering}

