% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawEEMgg.R
\name{drawEEMgg}
\alias{drawEEMgg}
\alias{drawEEMgg.EEM}
\alias{drawEEMgg.EEMweight}
\alias{drawEEMgg_internal}
\title{Draw contour for EEM data using ggplot2}
\usage{
drawEEMgg(x, ...)

\method{drawEEMgg}{EEM}(x, n, textsize = 20, color.palette = matlab.like,
  nlevels = 20, exlab = "Excitation wavelength [nm]",
  emlab = "Emission wavelength [nm]", main = NULL, has_legend = TRUE,
  zlim = NULL, breaks = waiver(), flipaxis = FALSE, ...)

\method{drawEEMgg}{EEMweight}(x, ncomp, textsize = 25,
  color.palette = matlab.like, nlevels = 20,
  exlab = "Excitation wavelength [nm]", emlab = "Emission wavelength [nm]",
  main = NULL, has_legend = TRUE, zlim = NULL, breaks = waiver(),
  flipaxis = FALSE, ...)
}
\arguments{
\item{x}{a list of EEM data generated by \code{\link[EEM]{readEEM}} function or 
EEMweight object generated by \code{\link[EEM]{extract}}-related functions.}

\item{...}{arguments for other methods}

\item{n}{sample number. The number should not exceed \code{length(EEM)}}

\item{textsize}{(optional) text size}

\item{color.palette}{(optional) contour color palette. See \code{\link[grDevices]{palette}} for more details}

\item{nlevels}{(optional) number of levels used to separate range of intensity value}

\item{exlab}{(optional) excitation-axis label}

\item{emlab}{(optional) emission-axis label}

\item{main}{(optional) plot title}

\item{has_legend}{logical value for legend}

\item{zlim}{zlim = c(min, max)}

\item{breaks}{breaks}

\item{flipaxis}{(optional) flip axis}

\item{ncomp}{number of components}
}
\value{
A figure is returned on the graphic device
}
\description{
This function draw contour for EEM data using ggplot2. Use `ggsave` to save the contours.
}
\details{
\code{\link{drawEEM}} is faster and should be used.
}
\section{Methods (by class)}{
\itemize{
\item \code{EEM}: draw EEM of EEM data created by \code{\link{readEEM}} function

\item \code{EEMweight}: draw contours of the output from \code{\link[EEM]{getLoading}} and 
\code{\link[EEM]{getReg}}.
}}
\examples{
\dontrun{
require(EEM)
require(ggplot2)
data(applejuice)
drawEEMgg(applejuice, 1) # draw EEM of sample no.1
drawEEMgg(applejuice, 1, color.palette = cm.colors) # draw EEM of sample no.31 with different color
drawEEMgg(applejuice, 1, nlevels = 10) # change nlevels

# manually define legend values
drawEEMgg(applejuice, 1, breaks = seq(from = 1000, to = 6000, by = 1000))

# can be combined with other ggplot2 commands
# add point to the plot
drawEEMgg(applejuice, 1) + geom_point(aes(x = 350, y = 500), pch = 17, cex = 10)

# add grid line to the plot
drawEEMgg(applejuice, 1) + theme(panel.grid = element_line(color = "grey"), 
panel.grid.major = element_line(colour = "grey"))

# add bg color
drawEEMgg(applejuice, 1, has_legend = FALSE) + geom_raster(aes(fill = value)) +
geom_contour(colour = "white")

}

}
\seealso{
\code{\link{drawEEM}}
}

